/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.source;

import com.hollingsworth.arsnouveau.common.block.tile.SourcelinkTile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.Event;

public class SourcelinkEventQueue {
    public static Map<String, Set<BlockPos>> posMap = new ConcurrentHashMap<String, Set<BlockPos>>();

    public static void addPosition(Level world, BlockPos pos) {
        String key = world.dimension().location().toString();
        if (!posMap.containsKey(key)) {
            posMap.put(key, new HashSet());
        }
        posMap.get(key).add(pos);
    }

    public static void addManaEvent(Level world, Class<? extends SourcelinkTile> tileType, int amount, Event event, BlockPos sourcePos) {
        ArrayList<BlockPos> stalePos = new ArrayList<BlockPos>();
        Set worldList = posMap.getOrDefault(world.dimension().location().toString(), new HashSet());
        for (BlockPos p : worldList) {
            if (!world.isLoaded(p)) continue;
            BlockEntity entity = world.getBlockEntity(p);
            if (world.getBlockEntity(p) == null || !(entity instanceof SourcelinkTile)) {
                stalePos.add(p);
                continue;
            }
            SourcelinkTile sourcelinkTile = (SourcelinkTile)entity;
            if (!entity.getClass().equals(tileType) || !sourcelinkTile.eventInRange(sourcePos, event) || !sourcelinkTile.canAcceptSource()) continue;
            sourcelinkTile.getManaEvent(sourcePos, amount);
            break;
        }
        for (BlockPos p : stalePos) {
            worldList.remove(p);
        }
    }
}

